local constants = {}

--constants.DISABLE_TECH_HIDING = false
constants.RUBIA_AUTO_ENTITY_PREFIX = "rubia-auto-variant-"
constants.WARNING_PRINT_SETTINGS = {color={r=0.9,g=0,b=0,a=1}}
constants.GREEN_PRINT_SETTINGS = {color={r=0.2,g=1,b=0.2,a=1}}
--constants.MEGABASE_MODE = settings.startup["rubia-megabase-mode"].value

--table<string of prototype type, names of prototypes[]> tied to biofusion sci
constants.BIOFUSION_LINE = {
    technology = {"rubia-biofusion-science-pack", "rubia-nutrients-from-sludge",
        "rubia-long-stack-inserter", "rubia-biofusion-promethium-science-pack",
        "rubia-cargo-landing-pad-capacity", "rubia-biochamber-productivity-bonus",
        "rubia-nutrient-productivity"
    },
    recipe = {"rubia-biofusion-science-pack", "rubia-biofusion-promethium-science-pack",
        "rubia-long-stack-inserter", "rubia-nutrients-from-sludge"
    },
}

--string[] of mod names known to remove surface restrictions
constants.NO_SURFACE_RESTRICTION_MODS = {
    "NoCraftingSurfaceCondition", "no-cond", "no_placement_restriction", 
    "surface_restriction_removal_rubia_compat", "surface_restriction_reforked"}
--string[] of mod names known to block biofusion
constants.BIOFUSION_BLOCKING_MODS = {"delete-gleba", "FarmingInAnotherWorld", "cheaper-delete-gleba"}

--[[string[] of items that are necessary to obtain by forage. Some are not available normally,
--and only come in from compat calls from other mods. When they are in forage, they are crucial!
constants.NECESSARY_FORAGE = {"gun-turret", 
    "chemical-plant", "electric-furnace", "electric-kiln",
    "kr-mineral-water-pumpjack",
}]]

--Mods known to change zoom extents.
constants.ZOOM_ALTERING_MODS = {"ExtraZoom", "Infinizoom", "Zoom-reset", 
    "FarZoom_Cybin", "Zooom", "Kux-ZoomRunning", "Autozoom"}
--Is TRUE if we know there is a mod present that alters zooom.
constants.HAS_ZOOM_ALTERING_MOD = false
local mod_dir = script and script.active_mods or mods
for _, entry in pairs(constants.ZOOM_ALTERING_MODS) do
    constants.HAS_ZOOM_ALTERING_MOD = constants.HAS_ZOOM_ALTERING_MOD or 
        (mod_dir and not not mod_dir[entry])
end
constants.ZOOM_ALTERATION_PERCENT = 20

return constants