local common_data = require("common-data-only")
local item_tints = require("__base__.prototypes.item-tints")
local merge = require("lib").merge
local item_sounds = require("__base__.prototypes.item_sounds")

data:extend({
	{
		type = "item",
		name = "cerys-discover-fulgoran-cryogenics",
		subgroup = "cerys-repair",
		order = "d",
		hidden = true,
		icon = "__PlanetsLib__/graphics/icons/research-progress-product.png",
		icon_size = 64,
		stack_size = 200,
		default_import_location = "cerys",
		weight = 1 * 1000 * 1000000,
		spoil_ticks = 1,
		auto_recycle = false,
	},
	{
		type = "item",
		name = "cerys-radiative-heater",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/radiative-heater.png",
		icon_size = 64,
		subgroup = "environmental-protection",
		order = "z-d[cerys]-b[radiative-tower]",
		default_import_location = "cerys",
		weight = 100 * 1000,
		stack_size = 20,
		place_result = "cerys-radiative-heater",
	},
})

data:extend({
	{
		type = "item",
		name = "cerys-fulgoran-radiative-tower",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/radiative-tower.png",
		icon_size = 64,
		subgroup = "cerys-entities",
		order = "a",
		hidden = true,
		default_import_location = "cerys",
		weight = 1000 * 1000,
		stack_size = 10,
		place_result = "cerys-fulgoran-radiative-tower-contracted-container",
	},
	{
		type = "item",
		name = "cerys-solar-wind-particle-ghost",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/entity/solar-wind-particle-ghost.png",
		icon_size = 32,
		hidden = true,
		stack_size = 1,
		spoil_ticks = 1,
		spoil_to_trigger_result = {
			items_per_trigger = 1,
			trigger = {
				type = "direct",
				action_delivery = {
					type = "instant",
					source_effects = {
						{
							type = "script",
							effect_id = "cerys-create-solar-wind-particle-ghost",
						},
					},
				},
			},
		},
	},
	{
		type = "item",
		name = "cerys-solar-ghost-maker",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/solar-ghost-maker.png",
		icon_size = 100,
		subgroup = "environmental-protection",
		order = "z-d[cerys]-a[solar-ghost-maker]",
		inventory_move_sound = item_sounds.electric_small_inventory_move,
		pick_sound = item_sounds.electric_small_inventory_pickup,
		drop_sound = item_sounds.electric_small_inventory_move,
		place_result = "cerys-solar-ghost-maker",
		stack_size = 50,
		default_import_location = "cerys",
	},
	{
		type = "item",
		name = "cerys-radiation-proof-inserter",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/radiation-proof-inserter.png",
		icon_size = 64,
		subgroup = "inserter",
		order = "w[cerys]",
		color_hint = { text = "R" },
		default_import_location = "cerys",
		inventory_move_sound = item_sounds.inserter_inventory_move,
		pick_sound = item_sounds.inserter_inventory_pickup,
		drop_sound = item_sounds.inserter_inventory_move,
		place_result = "cerys-radiation-proof-inserter",
		stack_size = 50,
	},
	{
		type = "module",
		name = "cerys-overclock-module",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/overclock-module-full.png",
		icon_size = 64,
		pictures = {
			sheet = {
				layers = {
					{
						size = 64,
						filename = "__Cerys-Moon-of-Fulgora__/graphics/icons/overclock-module-full.png",
						scale = 0.5,
					},
					{
						draw_as_glow = true,
						blend_mode = "additive",
						size = 64,
						filename = "__Cerys-Moon-of-Fulgora__/graphics/icons/overclock-module-lightning.png",
						scale = 0.5,
					},
				},
			},
		},
		subgroup = "module",
		order = "a[speed]-d[speed-module-4]-a[overclock-module]",
		color_hint = { text = "S" },
		category = "speed",
		tier = 4,
		inventory_move_sound = item_sounds.module_inventory_move,
		pick_sound = item_sounds.module_inventory_pickup,
		drop_sound = item_sounds.module_inventory_move,
		stack_size = 50,
		weight = 20 * 1000,
		effect = {
			speed = 1.0,
			consumption = 1.4,
			quality = -0.5,
			productivity = -0.05,
			pollution = 0.25,
		},
		default_import_location = "cerys",
		beacon_tint = {
			primary = { 0.441, 0.714, 1.000, 1.000 }, -- #70b6ffff
			secondary = { 0.388, 0.976, 1.000, 1.000 }, -- #63f8ffff
		},
		art_style = "vanilla", -- In vanilla, not present on prod modules for some reason?
		requires_beacon_alt_mode = false,
	},
	{
		type = "module",
		name = "cerys-radioactive-module-charged",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/radioactive-module-full.png",
		icon_size = 64,
		pictures = {
			sheet = {
				layers = {
					{
						size = 64,
						filename = "__Cerys-Moon-of-Fulgora__/graphics/icons/radioactive-module-full.png",
						scale = 0.5,
					},
					{
						draw_as_glow = true,
						blend_mode = "additive",
						size = 64,
						filename = "__Cerys-Moon-of-Fulgora__/graphics/icons/radioactive-module-glow.png",
						scale = 0.5,
					},
				},
			},
		},
		subgroup = "module",
		order = "c[productivity]-d[productivity-module-4]-a[radioactive-module]-a[charged]",
		color_hint = { text = "P" },
		category = "productivity",
		tier = 4,
		inventory_move_sound = item_sounds.module_inventory_move,
		pick_sound = item_sounds.module_inventory_pickup,
		drop_sound = item_sounds.module_inventory_move,
		stack_size = 50,
		weight = 20 * 1000,
		effect = {
			productivity = 0.18,
			consumption = 1,
			pollution = 0.14,
			speed = -0.2,
		},
		spoil_ticks = 8 * 60 * 60,
		spoil_result = "cerys-radioactive-module-decayed",
		default_import_location = "cerys",
	},
	{
		type = "module",
		name = "cerys-radioactive-module-decayed",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/radioactive-module-decayed.png",
		icon_size = 64,
		subgroup = "module",
		order = "c[productivity]-d[productivity-module-4]-a[radioactive-module]-b[decayed]",
		color_hint = { text = "P" },
		category = "productivity",
		tier = 4,
		inventory_move_sound = item_sounds.module_inventory_move,
		pick_sound = item_sounds.module_inventory_pickup,
		drop_sound = item_sounds.module_inventory_move,
		stack_size = 50,
		weight = 20 * 1000,
		effect = {
			productivity = 0.08,
			consumption = 0.7,
			pollution = 0.07,
			speed = -0.10,
		}, -- half as strong, Tier 2.5 equivalent
		default_import_location = "cerys",
	},
	{
		type = "tool",
		name = "cerysian-science-pack",
		localised_name = common_data.K2_INSTALLED and { "cerys.kr-cerysian-tech-card" } or nil,
		icon = common_data.K2_INSTALLED and "__Cerys-Moon-of-Fulgora__/graphics/icons/cerysian-tech-card.png"
			or "__Cerys-Moon-of-Fulgora__/graphics/icons/cerysian-science-pack.png",
		icon_size = 64,
		color_hint = { text = "R" },
		weight = 1 * 1000 * 1000000, -- Cannot be launched on rocket
		subgroup = "science-pack",
		order = common_data.K2_INSTALLED and "b02[automation-tech-card]-b"
			or "a[automation-science-pack]-b[cerysian-science-pack]",
		default_import_location = "cerys",
		inventory_move_sound = item_sounds.science_inventory_move,
		pick_sound = item_sounds.science_inventory_pickup,
		drop_sound = item_sounds.science_inventory_move,
		stack_size = 200,
		durability = 1,
		durability_description_key = "description.science-pack-remaining-amount-key",
		factoriopedia_durability_description_key = "description.factoriopedia-science-pack-remaining-amount-key",
		durability_description_value = "description.science-pack-remaining-amount-value",
		random_tint_color = item_tints.bluish_science,
	},

	merge(data.raw.item["fission-reactor-equipment"], {
		name = "mixed-oxide-reactor-equipment",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/mixed-oxide-reactor-equipment.png",
		icon_size = 64,
		place_as_equipment_result = "mixed-oxide-reactor-equipment",
		order = "a[energy-source]-b[fission-reactor]-b[mixed-oxide-reactor-equipment]",
		default_import_location = "cerys",
	}),
	{
		type = "item",
		flags = { "not-stackable" },
		name = "cerys-fulgoran-reactor-scaffold",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/scaffold.png",
		icon_size = 64,
		subgroup = "cerys-repair",
		order = "b",
		inventory_move_sound = item_sounds.metal_large_inventory_move,
		pick_sound = item_sounds.metal_large_inventory_pickup,
		drop_sound = item_sounds.metal_large_inventory_move,
		stack_size = 1,
		place_result = "cerys-fulgoran-reactor-scaffold",
	},
	{
		type = "item",
		name = "ancient-structure-repair-part",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/ancient-repair-part.png",
		flags = { "not-stackable" },
		icon_size = 64,
		subgroup = "cerys-repair",
		order = "a",
		inventory_move_sound = item_sounds.repair_pack_inventory_move,
		pick_sound = item_sounds.repair_pack_inventory_pickup,
		drop_sound = item_sounds.repair_pack_inventory_move,
		stack_size = 1,
		weight = 100 * 1000,
	},
	{
		type = "item",
		name = "cerys-charging-rod",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/charging-rod.png",
		icon_size = 116,
		subgroup = "energy",
		order = "e[accumulator]-z[charging-rod]",
		inventory_move_sound = item_sounds.electric_small_inventory_move,
		pick_sound = item_sounds.electric_small_inventory_pickup,
		drop_sound = item_sounds.electric_small_inventory_move,
		place_result = "cerys-charging-rod",
		stack_size = 50,
		default_import_location = "cerys",
		random_tint_color = item_tints.iron_rust,
	},
	{
		type = "item",
		name = "plutonium-fuel",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/plutonium-fuel.png",
		icon_size = 64,
		fuel_category = "chemical",
		subgroup = "plutonium-processing",
		order = "c-e",
		fuel_value = "5GJ",
		default_import_location = "cerys",
		fuel_acceleration_multiplier = 5,
		fuel_top_speed_multiplier = 1.5,
		inventory_move_sound = item_sounds.fuel_cell_inventory_move,
		pick_sound = item_sounds.fuel_cell_inventory_pickup,
		drop_sound = item_sounds.fuel_cell_inventory_move,
		stack_size = 5,
		weight = 20 * 1000,
	},
	{
		type = "item",
		name = "plutonium-238",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/plutonium-238.png",
		icon_size = 64,
		pictures = {
			layers = {
				{
					size = 64,
					filename = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/plutonium-238.png",
					scale = 0.5,
					mipmap_count = 4,
				},
				{
					draw_as_light = true,
					blend_mode = "additive",
					size = 64,
					filename = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/plutonium-238.png",
					scale = 0.5,
					tint = { 0.3, 0.3, 0.3, 0.3 },
				},
			},
		},
		subgroup = "plutonium-processing",
		order = "b-b",
		default_import_location = "cerys",
		color_hint = { text = "+" },
		inventory_move_sound = item_sounds.nuclear_inventory_move,
		pick_sound = item_sounds.nuclear_inventory_pickup,
		drop_sound = item_sounds.nuclear_inventory_move,
		stack_size = 100,
		weight = 10 * 1000,
	},
	{
		type = "item",
		name = "plutonium-239", -- Fissile
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/plutonium-239.png",
		icon_size = 64,
		subgroup = "plutonium-processing",
		order = "b-c",
		default_import_location = "cerys",
		inventory_move_sound = item_sounds.nuclear_inventory_move,
		pick_sound = item_sounds.nuclear_inventory_pickup,
		drop_sound = item_sounds.nuclear_inventory_move,
		stack_size = 100,
		weight = 10 * 1000,
	},
	merge(data.raw.item["lab"], {
		name = "cerys-lab",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/cerys-lab-cropped.png",
		icon_size = 64,
		order = "zzzz",
		place_result = "cerys-lab",
		default_import_location = "cerys",
	}),
	merge(data.raw.item["ice"], {
		name = "methane-ice",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/methane-ice.png",
		icon_size = 64,
		subgroup = "cerys-processes",
		order = "a-c[methane-ice]",
		default_import_location = "cerys",
	}),
	merge(data.raw.item["iron-ore"], {
		name = "cerys-nitrogen-rich-minerals",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/nitrogen-rich-minerals.png",
		icon_size = 64,
		subgroup = "cerys-processes",
		order = "a-d[nitrogen-rich-minerals]",
		pictures = {
			{
				size = 64,
				filename = "__Cerys-Moon-of-Fulgora__/graphics/icons/nitrogen-rich-minerals.png",
				scale = 0.5,
				mipmap_count = 4,
			},
			{
				size = 64,
				filename = "__Cerys-Moon-of-Fulgora__/graphics/icons/nitrogen-rich-minerals-1.png",
				scale = 0.5,
				mipmap_count = 4,
			},
			{
				size = 64,
				filename = "__Cerys-Moon-of-Fulgora__/graphics/icons/nitrogen-rich-minerals-2.png",
				scale = 0.5,
				mipmap_count = 4,
			},
			{
				size = 64,
				filename = "__Cerys-Moon-of-Fulgora__/graphics/icons/nitrogen-rich-minerals-3.png",
				scale = 0.5,
				mipmap_count = 4,
			},
		},
		default_import_location = "cerys",
	}),
	{
		type = "item",
		name = "cerys-nuclear-scrap",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/nuclear-scrap.png",
		icon_size = 64,
		pictures = {
			{
				size = 64,
				filename = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/nuclear-scrap.png",
				scale = 0.5,
				mipmap_count = 4,
			},
			{
				size = 64,
				filename = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/nuclear-scrap-1.png",
				scale = 0.5,
				mipmap_count = 4,
			},
			{
				size = 64,
				filename = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/nuclear-scrap-2.png",
				scale = 0.5,
				mipmap_count = 4,
			},
			{
				size = 64,
				filename = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/nuclear-scrap-3.png",
				scale = 0.5,
				mipmap_count = 4,
			},
			{
				size = 64,
				filename = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/nuclear-scrap-4.png",
				scale = 0.5,
				mipmap_count = 4,
			},
			{
				size = 64,
				filename = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/nuclear-scrap-5.png",
				scale = 0.5,
				mipmap_count = 4,
			},
		},
		subgroup = "cerys-processes",
		order = "a-a[nuclear-scrap]",
		inventory_move_sound = item_sounds.resource_inventory_move,
		pick_sound = item_sounds.resource_inventory_pickup,
		drop_sound = item_sounds.resource_inventory_move,
		stack_size = 50,
		default_import_location = "cerys",
		weight = 2 * 1000,
	},
	{
		type = "item",
		name = "cerys-mixed-oxide-reactor",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/mixed-oxide-reactor.png",
		icon_size = 64,
		subgroup = "energy",
		order = "f[nuclear-energy]-a[reactor]-a[mixed-oxide-reactor]",
		default_import_location = "cerys",
		weight = 1000 * 1000,
		stack_size = 10,
		place_result = "cerys-mixed-oxide-reactor",
	},
	-- {
	-- 	type = "item",
	-- 	name = "ancient-nuclear-fuel-cell",
	-- 	icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/ancient-nuclear-fuel-cell.png",
	-- 	subgroup = "cerys-processes",
	-- 	order = "a-b",
	-- 	inventory_move_sound = item_sounds.nuclear_inventory_move,
	-- 	pick_sound = item_sounds.nuclear_inventory_pickup,
	-- 	drop_sound = item_sounds.nuclear_inventory_move,
	-- 	stack_size = 50,
	-- 	weight = 100 * 1000,
	-- 	default_import_location = "cerys",
	-- },
	{
		-- Non-obtainable. It's here to make non-minable entities trigger a 'this entity cannot be mind' text when mined, without showing anything unusual in Factoriopedia.
		type = "item",
		name = "cerys-fulgoran-cryogenic-plant",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/cryogenic-plant.png",
		icon_size = 64,
		subgroup = "cerys-entities",
		order = "b",
		hidden = true,
		default_import_location = "cerys",
		weight = 1000 * 1000,
		stack_size = 10,
		place_result = "cerys-fulgoran-cryogenic-plant",
	},
	{
		-- Non-obtainable. It's here to make non-minable entities trigger a 'this entity cannot be mind' text when mined, without showing anything unusual in Factoriopedia.
		type = "item",
		name = "cerys-fulgoran-crusher",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/crusher.png",
		icon_size = 64,
		subgroup = "cerys-entities",
		order = "c",
		hidden = true,
		default_import_location = "cerys",
		weight = 1000 * 1000,
		stack_size = 5,
		place_result = "cerys-fulgoran-crusher",
	},
	{
		-- Non-obtainable. It's here to make non-minable entities trigger a 'this entity cannot be mind' text when mined, without showing anything unusual in Factoriopedia.
		type = "item",
		name = "cerys-fulgoran-reactor",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/fulgoran-reactor.png",
		icon_size = 64,
		subgroup = "cerys-entities",
		order = "d",
		hidden = true,
		default_import_location = "cerys",
		weight = 1000 * 1000,
		stack_size = 1,
		place_result = "cerys-fulgoran-reactor",
	},
	{
		-- Non-obtainable. It's here to make non-minable entities trigger a 'this entity cannot be mind' text when mined, without showing anything unusual in Factoriopedia.
		type = "item",
		name = "cerys-fulgoran-teleporter",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/teleporter.png",
		icon_size = 64,
		subgroup = "cerys-entities",
		order = "e",
		hidden = true,
		default_import_location = "cerys",
		weight = 1000 * 1000,
		stack_size = 1,
		place_result = "cerys-fulgoran-teleporter",
	},
	{
		type = "ammo",
		name = "plutonium-rounds-magazine",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/plutonium-rounds-magazine.png",
		icon_size = 64,
		pictures = {
			layers = {
				{
					size = 64,
					filename = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/plutonium-rounds-magazine.png",
					scale = 0.5,
					mipmap_count = 4,
				},
				{
					draw_as_light = true,
					size = 64,
					filename = "__base__/graphics/icons/uranium-rounds-magazine-light.png",
					scale = 0.5,
				},
			},
		},
		ammo_category = "bullet",
		ammo_type = {
			action = {
				type = "direct",
				action_delivery = {
					type = "instant",
					source_effects = {
						type = "create-explosion",
						entity_name = "explosion-gunshot",
					},
					target_effects = {
						{
							type = "create-entity",
							entity_name = "explosion-hit",
							offsets = { { 0, 1 } },
							offset_deviation = { { -0.5, -0.5 }, { 0.5, 0.5 } },
						},
						{
							type = "damage",
							damage = { amount = 48, type = "physical" },
						},
						{
							type = "activate-impact",
							deliver_category = "bullet",
						},
					},
				},
			},
		},
		magazine_size = 10,
		subgroup = "ammo",
		order = "a[basic-clips]-c[uranium-rounds-magazine]-b[plutonium-rounds-magazine]",
		inventory_move_sound = item_sounds.ammo_small_inventory_move,
		pick_sound = item_sounds.ammo_small_inventory_pickup,
		drop_sound = item_sounds.ammo_small_inventory_move,
		stack_size = 100,
		default_import_location = "cerys",
		weight = 40 * 1000,
	},
	-- {
	-- 	type = "ammo",
	-- 	name = "plutonium-cannon-shell",
	-- 	icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/plutonium-cannon-shell.png",
	-- 	pictures = {
	-- 		layers = {
	-- 			{
	-- 				size = 64,
	-- 				filename = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/plutonium-cannon-shell.png",
	-- 				scale = 0.5,
	-- 				mipmap_count = 4,
	-- 			},
	-- 			{
	-- 				draw_as_light = true,
	-- 				size = 64,
	-- 				filename = "__base__/graphics/icons/uranium-cannon-shell-light.png",
	-- 				scale = 0.5,
	-- 			},
	-- 		},
	-- 	},
	-- 	ammo_category = "cannon-shell",
	-- 	ammo_type = {
	-- 		range_modifier = 1.25,
	-- 		target_type = "direction",
	-- 		action = {
	-- 			type = "direct",
	-- 			action_delivery = {
	-- 				type = "projectile",
	-- 				projectile = "cerys-plutonium-cannon-projectile",
	-- 				starting_speed = 1,
	-- 				direction_deviation = 0.1,
	-- 				range_deviation = 0.1,
	-- 				max_range = 30,
	-- 				min_range = 5,
	-- 				source_effects = {
	-- 					type = "create-explosion",
	-- 					entity_name = "explosion-gunshot",
	-- 				},
	-- 			},
	-- 		},
	-- 	},
	-- 	subgroup = "ammo",
	-- 	order = "d[cannon-shell]-c[uranium]-b[plutonium]",
	-- 	inventory_move_sound = item_sounds.ammo_large_inventory_move,
	-- 	pick_sound = item_sounds.ammo_large_inventory_pickup,
	-- 	drop_sound = item_sounds.ammo_large_inventory_move,
	-- 	stack_size = 100,
	-- 	weight = 40 * 1000,
	-- },
	-- {
	-- 	type = "ammo",
	-- 	name = "explosive-plutonium-cannon-shell",
	-- 	icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/explosive-plutonium-cannon-shell.png",
	-- 	pictures = {
	-- 		layers = {
	-- 			{
	-- 				size = 64,
	-- 				filename = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/explosive-plutonium-cannon-shell.png",
	-- 				scale = 0.5,
	-- 				mipmap_count = 4,
	-- 			},
	-- 			{
	-- 				draw_as_light = true,
	-- 				size = 64,
	-- 				filename = "__base__/graphics/icons/uranium-cannon-shell-light.png",
	-- 				scale = 0.5,
	-- 			},
	-- 		},
	-- 	},
	-- 	ammo_category = "cannon-shell",
	-- 	ammo_type = {
	-- 		target_type = "direction",
	-- 		action = {
	-- 			type = "direct",
	-- 			action_delivery = {
	-- 				type = "projectile",
	-- 				projectile = "explosive-cerys-plutonium-cannon-projectile",
	-- 				starting_speed = 1,
	-- 				direction_deviation = 0.1,
	-- 				range_deviation = 0.1,
	-- 				max_range = 30,
	-- 				min_range = 5,
	-- 				source_effects = {
	-- 					type = "create-explosion",
	-- 					entity_name = "explosion-gunshot",
	-- 				},
	-- 			},
	-- 		},
	-- 	},
	-- 	subgroup = "ammo",
	-- 	order = "d[explosive-cannon-shell]-c[uranium]-b[plutonium]",
	-- 	inventory_move_sound = item_sounds.ammo_large_inventory_move,
	-- 	pick_sound = item_sounds.ammo_large_inventory_pickup,
	-- 	drop_sound = item_sounds.ammo_large_inventory_move,
	-- 	stack_size = 100,
	-- 	weight = 40 * 1000,
	-- },
	{
		type = "item",
		name = "mixed-oxide-fuel-cell",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/mixed-oxide-fuel-cell.png",
		icon_size = 64,
		pictures = {
			layers = {
				{
					size = 64,
					filename = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/mixed-oxide-fuel-cell.png",
					scale = 0.5,
					mipmap_count = 4,
				},
				{
					draw_as_light = true,
					size = 64,
					filename = "__base__/graphics/icons/uranium-fuel-cell-light.png",
					scale = 0.5,
				},
			},
		},
		subgroup = "plutonium-processing",
		order = "b-d",
		inventory_move_sound = item_sounds.nuclear_inventory_move,
		pick_sound = item_sounds.nuclear_inventory_pickup,
		drop_sound = item_sounds.nuclear_inventory_move,
		fuel_category = "nuclear-mixed-oxide",
		burnt_result = "depleted-mixed-oxide-fuel-cell",
		fuel_value = "96GJ",
		stack_size = 50,
		default_import_location = "cerys",
		weight = 100 * 1000,
	},
	{
		type = "item",
		name = "depleted-mixed-oxide-fuel-cell",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/nuclear/depleted-mixed-oxide-fuel-cell.png",
		icon_size = 64,
		subgroup = "plutonium-processing",
		order = "b-e",
		inventory_move_sound = item_sounds.nuclear_inventory_move,
		pick_sound = item_sounds.nuclear_inventory_pickup,
		drop_sound = item_sounds.nuclear_inventory_move,
		stack_size = 50,
		default_import_location = "cerys",
		weight = 100 * 1000,
	},
	{
		type = "ammo",
		name = "cerys-hydrogen-bomb",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/hydrogen-bomb.png",
		icon_size = 64,
		ammo_category = "rocket",
		ammo_type = {
			range_modifier = 2, -- from 1.5
			cooldown_modifier = 12, -- from 10
			target_type = "position",
			action = {
				type = "direct",
				action_delivery = {
					type = "projectile",
					projectile = "cerys-hydrogen-bomb-rocket",
					starting_speed = 0.05,
					source_effects = {
						type = "create-entity",
						entity_name = "explosion-hit",
					},
				},
			},
		},
		subgroup = "ammo",
		order = "d[rocket-launcher]-d[atomic-bomb]-b[hydrogen-bomb]",
		inventory_move_sound = item_sounds.atomic_bomb_inventory_move,
		pick_sound = item_sounds.atomic_bomb_inventory_pickup,
		drop_sound = item_sounds.atomic_bomb_inventory_move,
		stack_size = 10,
		weight = 1000 * 1000,
		send_to_orbit_mode = "manual",
	},
	{
		type = "ammo",
		name = "cerys-neutron-bomb",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/neutron-bomb.png",
		icon_size = 64,
		localised_description = {
			"cerys.neutron-bomb-description",
			{ "surface-property-unit.pressure", "5" },
		},
		ammo_category = "artillery-shell",
		ammo_type = {
			-- range_modifier = 0.25 -- Has no effect
			cooldown_modifier = 1.4,
			target_type = "position",
			action = {
				type = "direct",
				action_delivery = {
					type = "artillery",
					projectile = "cerys-neutron-bomb-projectile",
					starting_speed = 1,
					direction_deviation = 0,
					range_deviation = 0,
					source_effects = {
						type = "create-explosion",
						entity_name = "artillery-cannon-muzzle-flash",
					},
				},
			},
		},
		subgroup = "ammo",
		order = "d[explosive-cannon-shell]-d[artillery]-a[neutron-bomb]",
		inventory_move_sound = item_sounds.artillery_large_inventory_move,
		pick_sound = item_sounds.artillery_large_inventory_pickup,
		drop_sound = item_sounds.artillery_large_inventory_move,
		stack_size = 1,
		weight = 100 * 1000,
	},
})

if common_data.K2_INSTALLED then
	data:extend({
		{
			type = "item",
			name = "kr-cerysian-research-data",
			icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/cerysian-research-data.png",
			subgroup = "science-pack",
			order = "a0c[cerysian-research-data]",
			stack_size = 200,
			weight = 1 * kg,
			default_import_location = "cerys",
		},
	})
end
