local sounds = require("__base__/prototypes/entity/sounds")
local hit_effects = require("__base__/prototypes/entity/hit-effects")

data:extend({
	{
		type = "inserter",
		name = "cerys-radiation-proof-inserter",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/radiation-proof-inserter.png",
		icon_size = 64,
		flags = { "placeable-neutral", "placeable-player", "player-creation" },
		minable = { mining_time = 0.1, result = "cerys-radiation-proof-inserter" },
		max_health = 160,
		corpse = "cerys-radiation-proof-inserter-remnants",
		dying_explosion = "long-handed-inserter-explosion",
		order = "z-w[cerys]", -- Why do inserter entities also need order?
		resistances = {
			{
				type = "fire",
				percent = 90,
			},
		},
		collision_box = { { -0.15, -0.15 }, { 0.15, 0.15 } },
		selection_box = { { -0.4, -0.4 }, { 0.4, 0.4 } },
		damaged_trigger_effect = hit_effects.entity(),
		starting_distance = 1.7,
		pickup_position = { 0, -2.1 },
		insert_position = { 0, 2.2 },
		energy_per_movement = "15kJ",
		energy_per_rotation = "15kJ",
		extension_speed = 0.05,
		rotation_speed = 0.025,
		filter_count = 1,
		icon_draw_specification = { scale = 0.5 },
		hand_size = 1.2,
		energy_source = {
			type = "electric",
			usage_priority = "secondary-input",
			drain = "1.2kW",
		},
		fast_replaceable_group = "long-handed-inserter",
		impact_category = "metal",
		open_sound = sounds.inserter_open,
		close_sound = sounds.inserter_close,
		working_sound = sounds.inserter_long_handed,
		hand_base_picture = {
			filename = "__Cerys-Moon-of-Fulgora__/graphics/entity/inserter/inserter-hand-base.png",
			priority = "extra-high",
			width = 32,
			height = 136,
			scale = 0.25,
		},
		hand_closed_picture = {
			filename = "__Cerys-Moon-of-Fulgora__/graphics/entity/inserter/inserter-hand-closed.png",
			priority = "extra-high",
			width = 72,
			height = 164,
			scale = 0.25,
		},
		hand_open_picture = {
			filename = "__Cerys-Moon-of-Fulgora__/graphics/entity/inserter/inserter-hand-open.png",
			priority = "extra-high",
			width = 72,
			height = 164,
			scale = 0.25,
		},
		hand_base_shadow = {
			filename = "__base__/graphics/entity/burner-inserter/burner-inserter-hand-base-shadow.png",
			priority = "extra-high",
			width = 32,
			height = 132,
			scale = 0.25,
		},
		hand_closed_shadow = {
			filename = "__base__/graphics/entity/burner-inserter/burner-inserter-hand-closed-shadow.png",
			priority = "extra-high",
			width = 72,
			height = 164,
			scale = 0.25,
		},
		hand_open_shadow = {
			filename = "__base__/graphics/entity/burner-inserter/burner-inserter-hand-open-shadow.png",
			priority = "extra-high",
			width = 72,
			height = 164,
			scale = 0.25,
		},
		platform_picture = {
			sheet = {
				filename = "__Cerys-Moon-of-Fulgora__/graphics/entity/inserter/inserter-platform.png",
				priority = "extra-high",
				width = 105,
				height = 79,
				shift = util.by_pixel(1.5, 7.5 - 1),
				scale = 0.5,
			},
		},
		circuit_connector = circuit_connector_definitions["inserter"],
		circuit_wire_max_distance = inserter_circuit_wire_max_distance + 3,
	},
	{
		type = "corpse",
		name = "cerys-radiation-proof-inserter-remnants",
		icon = "__Cerys-Moon-of-Fulgora__/graphics/icons/radiation-proof-inserter.png",
		icon_size = 64,
		hidden_in_factoriopedia = true,
		flags = { "placeable-neutral", "not-on-map" },
		subgroup = "inserter-remnants",
		order = "a-c-a",
		selection_box = { { -0.5, -0.5 }, { 0.5, 0.5 } },
		tile_width = 1,
		tile_height = 1,
		selectable_in_game = false,
		time_before_removed = 60 * 60 * 15, -- 15 minutes
		expires = false,
		final_render_layer = "remnants",
		animation = make_rotated_animation_variations_from_sheet(4, {
			filename = "__Cerys-Moon-of-Fulgora__/graphics/entity/inserter/inserter-remnants.png",
			line_length = 1,
			width = 134,
			height = 94,
			direction_count = 1,
			shift = util.by_pixel(3.5, -2),
			scale = 0.5,
		}),
	},
})
