local formular_productivity = "(L)*100" -- angepasst für spätere Level
local lab_productivity = "(L)*50" -- angepasst für spätere Level

local productivity_recipes = {
  "landfill",
  "iron-plate",
  "copper-plate",
  -- Füge hier weitere Rezepte hinzu
  "steel-plate",
  "plastic-bar",
  "sulfuric-acid",
  "automation-science-pack",
  "logistic-science-pack",
  "military-science-pack",
  "chemical-science-pack",
  "production-science-pack",
  "rocket-part"
}

local technologies = {}

for _, recipe_name in pairs(productivity_recipes) do
  local tech_name = recipe_name .. "-productivity"
  local icon_path = nil

  icon_path = "__core__/graphics/icons/technology/effect-constant/effect-constant-recipe-productivity.png"

  local technology = {
    type = "technology",
    name = tech_name,
    icon_size = 256,
    icons = {
      {
        icon = icon_path,
        icon_size = 16
      }
    },
    effects = {
      {
        type = "change-recipe-productivity",
        recipe = recipe_name,
        change = 0.1 -- Produktivitätsbonus pro Level
      }
    },
    prerequisites = {
      "productivity-module-3" -- Voraussetzungen hier anpassen
    },
    unit = {
      count_formula = formular_productivity, -- Formel für Forschungskosten
      ingredients = {
        {"automation-science-pack", 1},
        {"logistic-science-pack", 1},
        {"chemical-science-pack", 1},
        {"production-science-pack", 1},
        {"space-science-pack", 1},
        -- Weitere Zutaten hier hinzufügen, falls nötig
      },
      time = 15 -- Zeit pro Level
    },
    max_level = "infinite",
    upgrade = true
  }

  table.insert(technologies, technology)
end
-- Forschungsgeschwindigkeit
table.insert(technologies, 
{
  type = "technology",
  name = "research-speed-7",
  icon_size = 256,
  icons = {
    {
      icon = "__base__/graphics/technology/research-speed.png",
      icon_size = 256
    },
    {
      icon = "__core__/graphics/icons/technology/constants/constant-speed.png",
      icon_size = 16
    }
  },
  effects = {
    {
      type = "laboratory-speed",
      modifier = 0.1 -- Geschwindigkeit pro Level
    }
  },
  prerequisites = {
    "research-speed-6" -- Voraussetzungen hier anpassen
  },
  unit = {
    count_formula = lab_productivity, -- Formel für Forschungskosten
    ingredients = {
      {"automation-science-pack", 1},
      {"logistic-science-pack", 1},
      {"chemical-science-pack", 1},
      {"production-science-pack", 1},
      {"space-science-pack", 1},
      -- Weitere Zutaten hier hinzufügen, falls nötig
    },
    time = 45 -- Zeit pro Level
  },
  max_level = "infinite",
  upgrade = true
})
-- Forschungsproduktivität
table.insert(technologies,
{
  type = "technology",
  name = "laboratory-productivity-1",
  icon_size = 128,
  icon = "__base__/graphics/technology/research-speed.png",
  effects =
  {
    {
      type = "laboratory-productivity",
      modifier = 0.25
    }
  },
  prerequisites = {"research-speed-6", "productivity-module-3"},
  unit =
  {
    count_formula = formular_productivity,
    ingredients =
    {
      {"automation-science-pack", 1},
      {"logistic-science-pack", 1},
      {"chemical-science-pack", 1},
      {"production-science-pack", 1}
    },
    time = 120
  },
  max_level = "infinite",
  upgrade = true,
  order = "c-k-f-f"
})

-- Materie
table.insert(technologies,  
{
  type = "technology",
  name = "matter-processing",
  icon_size = 64,
  icon = "__Valides_Endgame__/graphics/icons/matter.png",
  effects =
  {
    {
      type = "unlock-recipe",
      recipe = "iron-to-matter"
    },
    {
      type = "unlock-recipe",
      recipe = "copper-to-matter"
    },
    {
      type = "unlock-recipe",
      recipe = "solid-matter"
    }
  },
  prerequisites = {
    "space-science-pack"
  },
  unit =
  {
    count = 2500,
    ingredients = {
      {"matter-research-data", 1}
    },
    time = 45
  },
  order = "c-a"
})

-- Optimierung
table.insert(technologies,  
{
  type = "technology",
  name = "optimization",
  icon_size = 256,
  icon = "__Valides_Endgame__/graphics/technology/optimization-tech-card.png",
  effects =
  {
    
  },
  prerequisites = {
    "space-science-pack"
  },
  unit =
  {
    count = 5000,
    ingredients = {
      {"automation-science-pack", 1},
      {"logistic-science-pack", 1},
      {"chemical-science-pack", 1},
      {"utility-science-pack", 1},
    },
    time = 75
  },
  order = "c-a"
})

-- Singularität
table.insert(technologies,  
{
  type = "technology",
  name = "singularity",
  icon_size = 256,
  icon = "__Valides_Endgame__/graphics/technology/singularity-tech-card.png",
  effects =
  {
    
  },
  prerequisites = {
    "space-science-pack"
  },
  unit =
  {
    count = 8000,
    ingredients = {
      {"automation-science-pack", 1},
      {"logistic-science-pack", 1},
      {"chemical-science-pack", 1},
      {"production-science-pack", 1},
      {"utility-science-pack", 1},
    },
    time = 120
  },
  order = "c-a"
})

-- Gold
table.insert(technologies,  
{
  type = "technology",
  name = "gold-processing",
  icon_size = 64,
  icon = "__Valides_Endgame__/graphics/icons/gold-plate.png",
  effects =
  {
    {
      type = "unlock-recipe",
      recipe = "gold-plate"
    },
    {
      type = "unlock-recipe",
      recipe = "gold-wire"
    }
  },
  prerequisites = {
    "processing-unit"
  },
  unit =
  {
    count = 800,
    ingredients = {
      {"automation-science-pack", 1},
      {"logistic-science-pack", 1},
      {"chemical-science-pack", 1},
      {"production-science-pack", 1}
    },
    time = 60
  },
  order = "c-a"
})

-- Sonde
table.insert(technologies,  
{
  type = "technology",
  name = "advanced-satellite",
  icon_size = 64,
  icon = "__Valides_Endgame__/graphics/icons/advanced-satellite.png",
  effects =
  {
    {
      type = "unlock-recipe",
      recipe = "advanced-satellite"
    }
  },
  prerequisites = {
    "rocket-silo"
  },
  unit =
  {
    count = 5000,
    ingredients = {
      {"automation-science-pack", 1},
      {"logistic-science-pack", 1},
      {"chemical-science-pack", 1},
      {"production-science-pack", 1},
      {"space-science-pack", 1}
    },
    time = 60
  },
  order = "c-a"
})

-- Sonde
table.insert(technologies,  
{
  type = "technology",
  name = "advanced-lab",
  icon_size = 75,
  icon = "__Valides_Endgame__/graphics/icons/advanced-lab.png",
  effects =
  {
    {
      type = "unlock-recipe",
      recipe = "advanced-lab"
    }
  },
  prerequisites = {
    "advanced-satellite"
  },
  unit =
  {
    count = 8000,
    ingredients = {
      {"automation-science-pack", 1},
      {"logistic-science-pack", 1},
      {"chemical-science-pack", 1},
      {"production-science-pack", 1},
      {"utility-science-pack", 1},
      {"space-science-pack", 1}
    },
    time = 60
  },
  order = "c-a"
})

data:extend(technologies)