data:extend({
  -- Gold Plate Item
  {
    type = "item",
    name = "gold-plate",
    localised_name = {"item-name.gold-plate"},
    icons = {
      {
        icon = "__Valides_Endgame__/graphics/icons/gold-plate.png"
      }
    },
    icon_size = 64,
    icon_mipmaps = 4,
    stack_size = 100,
    subgroup = "intermediate-product",
    order = "a[gold-plate]"
  },
  -- Gold Wire
  {
    type = "item",
    name = "gold-wire",
    localised_name = {"item-name.gold-wire"},
    icons = {
      {
        icon = "__Valides_Endgame__/graphics/icons/gold-wire.png"
      }
    },
    icon_size = 64,
    icon_mipmaps = 4,
    stack_size = 200,
    subgroup = "intermediate-product",
    order = "a[gold-wire]"
  },
    -- verbesserter Satellit
    {
        type = "item",
        name = "advanced-satellite",
        icon = "__Valides_Endgame__/graphics/icons/advanced-satellite.png",
        icon_size = 64,
        subgroup = "intermediate-product",
        order = "z[matter]",
        stack_size = 1,
        rocket_launch_products = { -- Hier die Änderung:  Liste mit einem Eintrag
            {
                name = "matter-research-data",
                amount_min = 1,
                amount_max = 10,
            }
        },
        send_to_orbit_mode = "automated"
    },
    -- Forschungsdaten für Materie
    {
        type = "tool",
        name = "matter-research-data",
        icon = "__Valides_Endgame__/graphics/technology/matter-research-data.png",
        icon_size = 256,
        subgroup = "science-pack",
        order = "s",
        stack_size = 50,
        tool_category = "science-pack", -- füge eine neue Kategorie für das Tool hinzu oder verwende eine bestehende.
        durability = 20
    },
    -- Technologiekarte für Materie
    {
        type = "item",
        name = "matter-tech-card",
        icon = "__Valides_Endgame__/graphics/technology/matter-tech-card.png",
        icon_size = 256,
        subgroup = "science-pack",
        order = "s",
        stack_size = 50
    },
    -- Technologiekarte für Optimierung
    {
        type = "item",
        name = "optimization-tech-card",
        icon = "__Valides_Endgame__/graphics/technology/optimization-tech-card.png",
        icon_size = 256,
        subgroup = "science-pack",
        order = "s",
        stack_size = 50
    },
    -- Technologiekarte für Singularität
    {
      type = "item",
      name = "singularity-tech-card",
      icon = "__Valides_Endgame__/graphics/technology/singularity-tech-card.png",
      icon_size = 256,
      subgroup = "science-pack",
      order = "s",
      stack_size = 50
  },
    -- komprimierte Materie
    {
        type = "item",
        name = "solid-matter",
        icon = "__Valides_Endgame__/graphics/icons/solid-matter.png",
        icon_size = 64,
        subgroup = "intermediate-product",
        order = "c[matter]",
        stack_size = 50
    },
    -- Forschungsanlage
    {
      type = "item",
      name = "advanced-lab",
      icon = "__Valides_Endgame__/graphics/icons/advanced-lab.png",
      icon_size = 75, -- Oder die passende Größe
      subgroup = "production-machine", -- Oder eine passende Untergruppe
      order = "a[advanced-lab]",
      place_result = "advanced-lab", -- Wichtig! Verbindet das Item mit dem Gebäude
      stack_size = 50 -- Oder ein anderer Wert
      },
})