-- data.lua
require("ores.gold")
require("prototypes.recipes")
require("prototypes.technologies")
require("prototypes.fluids")
require("prototypes.items")
require("prototypes.buildings")


data:extend(
{
    -- Tempomodul Stufe 4 | Item
  {
    type = "module",
    name = "speed-module-4",
    icon = "__Valides_Endgame__/graphics/icons/speed-module-4.png",
    icon_size = 64,
    subgroup = "module",
    order = "c-d-e",
    stack_size = 50,
    category = "speed",  -- Kategorie hinzugefügt
    tier = 4,
    effect = {
        speed = 1,
        consumption = 1.4 
      },
    limitations =
    {
      "assembling-machine",
      "furnace",
      "mining-drill",
      "rocket-silo",
      "lab"
    }
  },
  -- Tempomodul Stufe 4 | Rezept
  {
    type = "recipe",
    name = "speed-module-4",
    enabled = false,
    ingredients =
    {
      {type="item", name="speed-module-3", amount=4},
      {type="item", name="processing-unit", amount=5},
      {type="item", name="advanced-circuit", amount=20},
      {type="item", name="low-density-structure", amount=20},
    },
    results = {{type="item", name="speed-module-4", amount=1}},
    energy_required = 60,
    requester_paste_multiplier = 1
  },
  -- Tempomodul Stufe 4 | Technologie
  {
    type = "technology",
    name = "speed-module-4",
    icon = "__Valides_Endgame__/graphics/technology/speed-module-4.png",
    icon_size = 256,
    effects =
    {
      {
        type = "unlock-recipe",
        recipe = "speed-module-4"
      }
    },
    prerequisites = {"speed-module-3", "efficiency-module-3", "productivity-module-3"},
    unit =
    {
      count = 500,
      time = 60,
      ingredients =
      {
        {"automation-science-pack", 1},
        {"logistic-science-pack", 1},
        {"chemical-science-pack", 1},
        {"production-science-pack", 1},
        {"utility-science-pack", 1},
      }
    },
    order = "c-k-g"
  },
  -- Tempomodul Stufe 5 | Item
  {
    type = "module",
    name = "speed-module-5",
    icon = "__Valides_Endgame__/graphics/icons/speed-module-5.png",
    icon_size = 64,
    subgroup = "module",
    order = "c-d-e",
    stack_size = 50,
    category = "speed",  -- Kategorie hinzugefügt
    tier = 5,
    effect = {
        speed = 1.5,
        consumption = 2.25 
      },
    limitations =
    {
      "assembling-machine",
      "furnace",
      "mining-drill",
      "rocket-silo",
      "lab"
    }
  },
  -- Tempomodul Stufe 5 | Rezept
  {
    type = "recipe",
    name = "speed-module-5",
    enabled = false,
    ingredients =
    {
      {type="item", name="speed-module-4", amount=8},
      {type="item", name="processing-unit", amount=20},
      {type="item", name="advanced-circuit", amount=100},
      {type="item", name="low-density-structure", amount=50},
    },
    results = {{type="item", name="speed-module-5", amount=1}},
    energy_required = 120,
    requester_paste_multiplier = 1
  },
  -- Tempomodul Stufe 5 | Technologie
  {
    type = "technology",
    name = "speed-module-5",
    icon = "__Valides_Endgame__/graphics/technology/speed-module-5.png",
    icon_size = 256,
    effects =
    {
      {
        type = "unlock-recipe",
        recipe = "speed-module-5"
      }
    },
    prerequisites = {"speed-module-4", "rocket-silo"},
    unit =
    {
      count = 1000,
      time = 120,
      ingredients =
      {
        {"automation-science-pack", 1},
        {"logistic-science-pack", 1},
        {"chemical-science-pack", 1},
        {"production-science-pack", 1},
        {"utility-science-pack", 1},
        {"space-science-pack", 1},
      }
    },
    order = "c-k-g"
  },
}
)

