local ps = require("lib.planet-str")

data:extend{
    { --Planet-string property, hidden property based on an encoded str of <=8 bytes/characters.
      --Can be used to map individual planets to virtually anything.
      --Example: Reserving rocket part recipes for a single planet.
      --Example: Establishing relationships between moons and planets that can be read in control.

      --Generally generated by truncating planet names down to 8 characters.
      --If two planets share the first 8 characters, this can cause issues, but that is unlikely to happen.
        type="surface-property",
        name="planet-str",
        hidden=true, --This line does nothing. The locale is what determines if surface properties are hidden or not.
        hidden_in_factoriopedia=true,
        default_value=0, --Strings can't be stored in surface properties, so we need a script to convert strings into doubles.
        order="zzz"
    },
    {
      type="surface-property",
        name="parent-planet-str",
        hidden=true, --This line does nothing. The locale is what determines if surface properties are hidden or not.
        hidden_in_factoriopedia=true,
        default_value=0, --Strings can't be stored in surface properties, so we need a script to convert strings into doubles.
        order="zzzz"
    }
}

ps.set_planet_str(data.raw.planet["nauvis"],"nauvis")
ps.set_planet_str(data.raw.planet["vulcanus"],"vulcanus")
ps.set_planet_str(data.raw.planet["gleba"],"gleba")
ps.set_planet_str(data.raw.planet["fulgora"],"fulgora")
ps.set_planet_str(data.raw.planet["aquilo"],"aquilo")