local rocket_lift_weight = data.raw["utility-constants"]["default"].rocket_lift_weight

local items_per_rocket = {

    -- Logistics

    { "wooden-chest", 50 },
    { "iron-chest", 50 },
    { "steel-chest", 50 },
    { "storage-tank", 50 },
    { "transport-belt", 100 },
    { "fast-transport-belt", 100 },
    { "express-transport-belt", 100 },
    { "turbo-transport-belt", 50 },
    { "underground-belt", 50 },
    { "fast-underground-belt", 50 },
    { "express-underground-belt", 50 },
    { "turbo-underground-belt", 25 },
    { "splitter", 50 },
    { "fast-splitter", 50 },
    { "express-splitter", 50 },
    { "turbo-splitter", 25 },
    { "burner-inserter", 50 },
    { "inserter", 50 },
    { "long-handed-inserter", 50 },
    { "fast-inserter", 50 },
    { "bulk-inserter", 50 },
    { "stack-inserter", 50 },
    { "small-electric-pole", 50 },
    { "medium-electric-pole", 50 },
    { "big-electric-pole", 50 },
    { "substation", 50 },
    { "pipe", 200 },
    { "pipe-to-ground", 50 },
    { "pump", 50 },
    { "rail", 100, "rail-planner" },
    { "rail-ramp", 1, "rail-planner" },
    { "rail-support", 5 },
    { "train-stop", 10 },
    { "rail-signal", 50 },
    { "rail-chain-signal", 50 },
    { "locomotive", 5, "item-with-entity-data" },
    { "cargo-wagon", 5, "item-with-entity-data" },
    { "fluid-wagon", 5, "item-with-entity-data" },
    { "artillery-wagon", 1, "item-with-entity-data" },
    { "car", 1, "item-with-entity-data" },
    { "tank", 1, "item-with-entity-data" },
    { "spidertron", 1, "item-with-entity-data" },
    { "logistic-robot", 50 },
    { "construction-robot", 50 },
    { "active-provider-chest", 50 },
    { "passive-provider-chest", 50 },
    { "storage-chest", 50 },
    { "buffer-chest", 50 },
    { "requester-chest", 50 },
    { "roboport", 10 },
    { "small-lamp", 50 },
    { "arithmetic-combinator", 50 },
    { "decider-combinator", 50 },
    { "selector-combinator", 50 },
    { "constant-combinator", 50 },
    { "power-switch", 10 },
    { "programmable-speaker", 10 },
    { "display-panel", 10 },
    { "stone-brick", 500 },
    { "concrete", 100 },
    { "hazard-concrete", 100 },
    { "refined-concrete", 100 },
    { "refined-hazard-concrete", 100 },
    { "landfill", 20 },
    { "artificial-yumako-soil", 100 / 3 * 2 }, -- 67
    { "overgrowth-yumako-soil", 100 / 7 }, -- 14
    { "artificial-jellynut-soil", 100 / 3 * 2 }, -- 67
    { "overgrowth-jellynut-soil", 100 / 7 }, -- 14
    { "ice-platform", 100 },
    { "foundation", 50 },
    { "cliff-explosives", 20, "capsule" },

    -- Production

    { "repair-pack", 100, "repair-tool" },
    { "boiler", 50 },
    { "steam-engine", 10 },
    { "solar-panel", 50 },
    { "accumulator", 50 },
    { "nuclear-reactor", 1 },
    { "heat-pipe", 50 },
    { "heat-exchanger", 50 },
    { "steam-turbine", 10 },
    { "fusion-reactor", 1 },
    { "fusion-generator", 5 },
    { "burner-mining-drill", 50 },
    { "electric-mining-drill", 50 },
    { "big-mining-drill", 20 },
    { "offshore-pump", 20 },
    { "pumpjack", 20 },
    { "stone-furnace", 50 },
    { "steel-furnace", 50 },
    { "electric-furnace", 50 },
    { "foundry", 5 },
    { "recycler", 10 },
    { "agricultural-tower", 20 },
    { "biochamber", 20 },
    { "captive-biter-spawner", 1 },
    { "assembling-machine-1", 50 },
    { "assembling-machine-2", 50 },
    { "assembling-machine-3", 25 },
    { "oil-refinery", 10 },
    { "chemical-plant", 10 },
    { "centrifuge", 1 },
    { "electromagnetic-plant", 5 },
    { "cryogenic-plant", 5 },
    { "lab", 10 },
    { "biolab", 1 },
    { "lightning-rod", 50 },
    { "lightning-collector", 20 },
    { "heating-tower", 10 },
    { "beacon", 20 },
    { "speed-module", 50, "module" },
    { "speed-module-2", 50, "module" },
    { "speed-module-3", 50, "module" },
    { "efficiency-module", 50, "module" },
    { "efficiency-module-2", 50, "module" },
    { "efficiency-module-3", 50, "module" },
    { "productivity-module", 50, "module" },
    { "productivity-module-2", 50, "module" },
    { "productivity-module-3", 50, "module" },
    { "quality-module", 50, "module" },
    { "quality-module-2", 50, "module" },
    { "quality-module-3", 50, "module" },

    -- Intermediate products

    { "wood", 500 },
    { "coal", 500 },
    { "stone", 500 },
    { "iron-ore", 500 },
    { "copper-ore", 500 },
    { "uranium-ore", 200 },
    { "raw-fish", 300, "capsule" },
    { "ice", 1000 },
    { "iron-plate", 1000 },
    { "copper-plate", 1000 },
    { "steel-plate", 400 },
    { "solid-fuel", 1000 },
    { "plastic-bar", 2000 },
    { "sulfur", 1000 },
    { "battery", 400 },
    { "explosives", 500 },
    { "carbon", 1000 },
    { "water-barrel", 100 },
    { "crude-oil-barrel", 100 },
    { "petroleum-gas-barrel", 100 },
    { "light-oil-barrel", 100 },
    { "heavy-oil-barrel", 100 },
    { "lubricant-barrel", 100 },
    { "sulfuric-acid-barrel", 100 },
    { "fluoroketone-hot-barrel", 100 },
    { "fluoroketone-cold-barrel", 100 },
    { "iron-gear-wheel", 1000 },
    { "iron-stick", 2000 },
    { "copper-cable", 4000 },
    { "barrel", 200 },
    { "electronic-circuit", 2000 },
    { "advanced-circuit", 1000 },
    { "processing-unit", 300 },
    { "engine-unit", 400 },
    { "electric-engine-unit", 400 },
    { "flying-robot-frame", 150 },
    { "low-density-structure", 200 },
    { "rocket-fuel", 100 },
    { "uranium-235", 20 },
    { "uranium-238", 20 },
    { "uranium-fuel-cell", 10 },
    { "depleted-uranium-fuel-cell", 10 },
    { "nuclear-fuel", 10 },
    { "calcite", 500 },
    { "tungsten-ore", 100 },
    { "tungsten-carbide", 500 },
    { "tungsten-plate", 250 },
    { "scrap", 500 },
    { "holmium-ore", 500 },
    { "holmium-plate", 1000 },
    { "superconductor", 1000 },
    { "supercapacitor", 500 },
    { "yumako-seed", 100 },
    { "jellynut-seed", 100 },
    { "yumako", 1000, "capsule" },
    { "jellynut", 1000, "capsule" },
    { "iron-bacteria", 1000 },
    { "copper-bacteria", 1000 },
    { "spoilage", 2000 },
    { "nutrients", 2000 },
    { "bioflux", 1000, "capsule" },
    { "yumako-mash", 2000, "capsule" },
    { "jelly", 2000, "capsule" },
    { "carbon-fiber", 500 },
    { "biter-egg", 500 },
    { "pentapod-egg", 500 },
    { "tree-seed", 500 },
    { "lithium", 250 },
    { "lithium-plate", 500 },
    { "quantum-processor", 200 },
    { "fusion-power-cell", 50 },
    { "automation-science-pack", 1000, "tool" },
    { "logistic-science-pack", 1000, "tool" },
    { "military-science-pack", 1000, "tool" },
    { "chemical-science-pack", 1000, "tool" },
    { "production-science-pack", 1000, "tool" },
    { "utility-science-pack", 1000, "tool" },
    { "space-science-pack", 1000, "tool" },
    { "metallurgic-science-pack", 1000, "tool" },
    { "agricultural-science-pack", 1000, "tool" },
    { "electromagnetic-science-pack", 1000, "tool" },
    { "cryogenic-science-pack", 1000, "tool" },
    { "promethium-science-pack", 1000, "tool" },

    -- Space

    { "rocket-silo", 0.1 },
    { "rocket-part", 50 },
    { "cargo-landing-pad", 1 },
    { "space-platform-foundation", 50 },
    { "cargo-bay", 10 },
    { "asteroid-collector", 10 },
    { "crusher", 10 },
    { "thruster", 5 },
    { "space-platform-starter-pack", 1, "space-platform-starter-pack" },
    { "space-platform-hub", 1 },
    { "metallic-asteroid-chunk", 10 },
    { "carbonic-asteroid-chunk", 10 },
    { "oxide-asteroid-chunk", 10 },
    { "promethium-asteroid-chunk", 10 },

    -- Combat

    { "submachine-gun", 5, "gun" },
    { "railgun", 1, "gun" },
    { "teslagun", 5, "gun" },
    { "shotgun", 5, "gun" },
    { "combat-shotgun", 5, "gun" },
    { "rocket-launcher", 5, "gun" },
    { "flamethrower", 5, "gun" },
    { "firearm-magazine", 100, "ammo" },
    { "piercing-rounds-magazine", 50, "ammo" },
    { "uranium-rounds-magazine", 25, "ammo" },
    { "shotgun-shell", 100, "ammo" },
    { "piercing-shotgun-shell", 50, "ammo" },
    { "cannon-shell", 50, "ammo" },
    { "explosive-cannon-shell", 50, "ammo" },
    { "uranium-cannon-shell", 25, "ammo" },
    { "explosive-uranium-cannon-shell", 25, "ammo" },
    { "artillery-shell", 10, "ammo" },
    { "rocket", 25, "ammo" },
    { "explosive-rocket", 25, "ammo" },
    { "atomic-bomb", 0.75, "ammo" },
    { "capture-robot-rocket", 10, "ammo" },
    { "flamethrower-ammo", 100, "ammo" },
    { "railgun-ammo", 5, "ammo" },
    { "tesla-ammo", 100, "ammo" },
    { "grenade", 100, "capsule" },
    { "cluster-grenade", 25, "capsule" },
    { "poison-capsule", 100, "capsule" },
    { "slowdown-capsule", 100, "capsule" },
    { "defender-capsule", 100, "capsule" },
    { "distractor-capsule", 50, "capsule" },
    { "destroyer-capsule", 25, "capsule" },
    { "light-armor", 1, "armor" },
    { "heavy-armor", 1, "armor" },
    { "modular-armor", 1, "armor" },
    { "power-armor", 1, "armor" },
    { "power-armor-mk2", 1, "armor" },
    { "mech-armor", 1, "armor" },
    { "solar-panel-equipment", 20 },
    { "fission-reactor-equipment", 4 },
    { "fusion-reactor-equipment", 1 },
    { "battery-equipment", 20 },
    { "battery-mk2-equipment", 10 },
    { "battery-mk3-equipment", 5 },
    { "belt-immunity-equipment", 20 },
    { "exoskeleton-equipment", 12.6317 },
    { "personal-roboport-equipment", 9.4118 },
    { "personal-roboport-mk2-equipment", 2.6740 },
    { "night-vision-equipment", 20 },
    { "toolbelt-equipment", 20 },
    { "energy-shield-equipment", 20 },
    { "energy-shield-mk2-equipment", 10 },
    { "personal-laser-defense-equipment", 5 },
    { "discharge-defense-equipment", 4.2857 },
    { "stone-wall", 100 },
    { "gate", 50 },
    { "radar", 50 },
    { "land-mine", 100 },
    { "gun-turret", 50 },
    { "laser-turret", 25 },
    { "flamethrower-turret", 20 },
    { "artillery-turret", 5 },
    { "rocket-turret", 10 },
    { "tesla-turret", 10 },
    { "railgun-turret", 1 }
}

for _, entry in pairs(items_per_rocket) do
    local name = entry[1]
    local amount = entry[2]
    local type = entry[3] or "item"
    local item = data.raw[type][name]
    if item and not item.weight then
        item.weight = rocket_lift_weight / amount
    end
end