local constants = require("prototypes.constants")

local circuit_connector = circuit_connector_definitions.create_vector(universal_connector_template, {
  {
    variation = 24,
    main_offset = util.by_pixel(-22, 5),
    shadow_offset = util.by_pixel(0, 0),
    show_shadow = false,
  },
  {
    variation = 26,
    main_offset = util.by_pixel(22, 15),
    shadow_offset = util.by_pixel(24, 15),
    show_shadow = true,
  },
  {
    variation = 24,
    main_offset = util.by_pixel(-22, 5),
    shadow_offset = util.by_pixel(0, 0),
    show_shadow = false,
  },
  {
    variation = 26,
    main_offset = util.by_pixel(22, 15),
    shadow_offset = util.by_pixel(24, 15),
    show_shadow = true,
  },
})

data:extend({
  {
    type = "recipe",
    name = "non-return-duct",
    enabled = false,
    category = "crafting",
    energy_required = 2.0,
    ingredients = {
      { type = "item", name = "iron-plate", amount = 8 },
      { type = "item", name = "iron-gear-wheel", amount = 4 },
    },
    results = { { type = "item", name = "non-return-duct", amount = 1 } },
  },
  {
    type = "item",
    name = "non-return-duct",
    icon = "__FluidMustFlow__/graphics/icons/buildings/non-return-duct.png",
    subgroup = "ducts",
    order = "d[pipe]-h[non-return-duct]",
    place_result = "non-return-duct",
    stack_size = 10,
  },
  {
    type = "pump",
    name = "non-return-duct",
    icon = "__FluidMustFlow__/graphics/icons/buildings/non-return-duct.png",
    flags = { "placeable-neutral", "player-creation" },
    minable = { mining_time = 0.4, result = "non-return-duct" },
    fast_replaceable_group = "duct-intermediate-points",
    collision_box = { { -0.77, -0.9 }, { 0.77, 0.9 } },
    selection_box = { { -1, -1 }, { 1, 1 } },
    heating_energy = feature_flags.freezing and "100kW" or nil,
    pumping_speed = 120,
    energy_source = { type = "void" },
    energy_usage = "1W",
    fluid_box = {
      volume = constants.volume * 2,
      pipe_covers = nil,
      pipe_connections = {
        {
          direction = defines.direction.north,
          connection_category = "ducts",
          position = { 0, -0.5 },
          flow_direction = "output",
        },
        {
          direction = defines.direction.south,
          connection_category = "ducts",
          position = { 0, 0.5 },
          flow_direction = "input",
        },
      },
      max_pipeline_extent = constants.extent,
    },
    max_health = 800,
    corpse = "small-remnants",
    dying_explosion = "pump-explosion",
    resistances = data.raw["pump"]["pump"].resistances,
    vehicle_impact_sound = { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    animations = {
      east = {
        layers = {
          {
            animation_speed = 1,
            filename = "__FluidMustFlow__/graphics/buildings/non-return-duct/non-return-duct-right.png",
            frame_count = 16,
            height = 256,
            line_length = 4,
            priority = "high",
            scale = 0.5,
            width = 256,
          },
          {
            animation_speed = 1,
            draw_as_shadow = true,
            filename = "__FluidMustFlow__/graphics/buildings/non-return-duct/non-return-duct-horizontal-shadow.png",
            frame_count = 16,
            height = 256,
            line_length = 4,
            priority = "high",
            scale = 0.5,
            width = 256,
          },
        },
      },
      north = {
        layers = {
          {
            animation_speed = 1,
            filename = "__FluidMustFlow__/graphics/buildings/non-return-duct/non-return-duct-up.png",
            frame_count = 16,
            height = 256,
            line_length = 4,
            priority = "high",
            scale = 0.5,
            width = 256,
          },
          {
            animation_speed = 1,
            draw_as_shadow = true,
            filename = "__FluidMustFlow__/graphics/buildings/non-return-duct/non-return-duct-vertical-shadow.png",
            frame_count = 16,
            height = 256,
            line_length = 4,
            priority = "high",
            scale = 0.5,
            width = 256,
          },
        },
      },
      south = {
        layers = {
          {
            animation_speed = 1,
            filename = "__FluidMustFlow__/graphics/buildings/non-return-duct/non-return-duct-down.png",
            frame_count = 16,
            height = 256,
            line_length = 4,
            priority = "high",
            scale = 0.5,
            width = 256,
          },
          {
            animation_speed = 1,
            draw_as_shadow = true,
            filename = "__FluidMustFlow__/graphics/buildings/non-return-duct/non-return-duct-vertical-shadow.png",
            frame_count = 16,
            height = 256,
            line_length = 4,
            priority = "high",
            scale = 0.5,
            width = 256,
          },
        },
      },
      west = {
        layers = {
          {
            animation_speed = 1,
            filename = "__FluidMustFlow__/graphics/buildings/non-return-duct/non-return-duct-left.png",
            frame_count = 16,
            height = 256,
            line_length = 4,
            priority = "high",
            scale = 0.5,
            width = 256,
          },
          {
            animation_speed = 1,
            draw_as_shadow = true,
            filename = "__FluidMustFlow__/graphics/buildings/non-return-duct/non-return-duct-horizontal-shadow.png",
            frame_count = 16,
            height = 256,
            line_length = 4,
            priority = "high",
            scale = 0.5,
            width = 256,
          },
        },
      },
    },
    fluid_wagon_connector_frame_count = 0,
    circuit_connector = circuit_connector,
    circuit_wire_max_distance = data.raw["storage-tank"]["storage-tank"].circuit_wire_max_distance,
  },
})
