local hit_effects = require ("__base__/prototypes/entity/hit-effects")
local item_sounds = require("__base__/prototypes/item_sounds")

require ("circuit-connector-sprites")
local ccn = { variation = 26, main_offset = util.by_pixel(3, 5.5), shadow_offset = util.by_pixel(7.5, 7.5), show_shadow = true }
local rci_circuit_connector = circuit_connector_definitions.create_vector(universal_connector_template, { ccn, ccn, ccn, ccn })

local function rci_rocket_unlock_recipe(recname)
	table.insert(data.raw.technology["rocket-silo"].effects, { type = "unlock-recipe", recipe = recname })
end
local rocketizer_recipe = {
	type = "recipe",
	name = "rci-rocketizer",
	enabled = false,
	ingredients = {{type = "item", name = "steel-chest", amount = 1}},
	results = {{type="item", name="rci-rocketizer", amount=1}}
}
local rocketizer_item = {
	type = "item",
	name = "rci-rocketizer",
	icon = "__RocketCargoInsertion__/graphics/icons/rci-rocketizer.png",
	subgroup = "rci-rocketry",
	order = "zzzzz",
	inventory_move_sound = item_sounds.metal_chest_inventory_move,
	pick_sound = item_sounds.metal_chest_inventory_pickup,
	drop_sound = item_sounds.metal_chest_inventory_move,
	place_result = "rci-rocketizer",
	stack_size = 50
}

if (settings.startup["rci-mode"].value == "proxy") then
	rocketizer_item.subgroup = "space-interactors"
	data:extend({
		rocketizer_recipe,
		rocketizer_item,
		{
			type = "proxy-container",
			name = "rci-rocketizer",
			icon = "__RocketCargoInsertion__/graphics/icons/rci-rocketizer.png",
			flags = {"placeable-neutral", "player-creation", "no-automated-item-removal"},
			minable = {mining_time = 0.1, result = "rci-rocketizer"},
			max_health = 100,
			corpse = "steel-chest-remnants",
			dying_explosion = "steel-chest-explosion",
			open_sound = { filename = "__base__/sound/metallic-chest-open.ogg", volume=0.43 },
			close_sound = { filename = "__base__/sound/metallic-chest-close.ogg", volume = 0.43 },
			collision_box = {{-0.35, -0.35}, {0.35, 0.35}},
			fast_replaceable_group = "container",
			selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
			damaged_trigger_effect = hit_effects.entity(),
			impact_category = "metal",
			draw_inventory_content = false,
			icon_draw_specification = {scale = 0.7},
			circuit_connector = circuit_connector_definitions["chest"],
			circuit_wire_max_distance = default_circuit_wire_max_distance,
		
			picture = {
				layers = {
					{
						filename = "__RocketCargoInsertion__/graphics/entity/rocketizer/rocketizer.png",
						priority = "extra-high",
						width = 64,
						height = 80,
						shift = util.by_pixel(-0.25, -0.5),
						scale = 0.5
					},
					{
						filename = "__RocketCargoInsertion__/graphics/entity/rocketizer/rocketizer-shadow.png",
						priority = "extra-high",
						width = 110,
						height = 46,
						shift = util.by_pixel(12.25, 8),
						draw_as_shadow = true,
						scale = 0.5
					}
				}
			}
		}
	
	})
	
	rci_rocket_unlock_recipe("rci-rocketizer")	
	return
end

local productivity_recipes = {}
local subPU = settings.startup["rci-processing-unit"].value
local subLDS = settings.startup["rci-low-density-structure"].value
local subFuel = settings.startup["rci-rocket-fuel"].value
local siloRecipes = settings.startup["rci-silo-recipes"].value

local function rci_make_rocket_recipe(newname, order)
	local rec = util.table.deepcopy(data.raw.recipe["rocket-part"])
	rec.name = newname
	rec.order = order
	rec.localised_name = { "item-name.rocket-part" }
	rec.auto_recycle = false
	rec.allow_decomposition = false
    rec.always_show_made_in = true
	return rec
end

local function rci_make_part_recipe(basepartname, rcipart)
	local rec = {
		type = "recipe",
		name = rcipart.name,
		energy_required = 0.0625,
		enabled = false,
		category = "rci-rocketizer",
		ingredients = {{type="item", name=basepartname, amount=1}},
		results = {{type="item", name=rcipart.name, amount=1}},
		allow_productivity = false	
	}
	return rec
end

local function rci_make_combo_recipe(recipe_name)
	local rec = {
		type = "recipe",
		name = recipe_name,
		icon = "__RocketCargoInsertion__/graphics/icons/rci-rocket-part-full.png",
		energy_required = 0.1875,
		enabled = false,
		category = "rci-rocketizer",
		subgroup = "rci-rocketry",		
		main_product = "",
		order = "a-x",
		ingredients =
		{
		  {type = "item", name = "processing-unit", amount = 1},
		  {type = "item", name = "low-density-structure", amount = 1},
		  {type = "item", name = "rocket-fuel", amount = 1}
		},
		results =
		{
		  {type = "item", name = "rci-processing-unit", amount = 1},
		  {type = "item", name = "rci-low-density-structure", amount = 1},
		  {type = "item", name = "rci-rocket-fuel", amount = 1}
		},
		allow_productivity = false	
	}
	return rec
end

local function rci_substitute(rec, pu, lds, fuel)
	for i=1,#rec.ingredients do
		local iname = rec.ingredients[i].name
		local subst = false
		if (iname == "processing-unit" and subPU and pu) then
			subst = true
		elseif (iname == "low-density-structure" and subLDS and lds) then
			subst = true
		elseif (iname == "rocket-fuel" and subFuel and fuel) then
			subst = true
		end
		if (subst) then rec.ingredients[i].name = "rci-" .. iname end
	end
end

local rci_category = {
	type = "item-subgroup",
	name = "rci-rocketry",
	group = "space",
	order = "izz"
}
local rci_rocketizer_crafting = {
	type = "recipe-category",
	name = "rci-rocketizer",
}
local rocketizer_entity = {
	type = "assembling-machine",
	name = "rci-rocketizer",
	icon = "__RocketCargoInsertion__/graphics/icons/rci-rocketizer.png",
	flags = {"placeable-neutral", "placeable-player", "player-creation"},
	minable = {mining_time = 0.2, result = "rci-rocketizer"},
    max_health = 350,
    corpse = "steel-chest-remnants",
    dying_explosion = "steel-chest-explosion",
    open_sound = { filename = "__base__/sound/metallic-chest-open.ogg", volume=0.43 },
    close_sound = { filename = "__base__/sound/metallic-chest-close.ogg", volume = 0.43 },
    resistances =
    {
      {
        type = "fire",
        percent = 90
      },
      {
        type = "impact",
        percent = 60
      }
    },
	
    collision_box = {{-0.35, -0.35}, {0.35, 0.35}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
	icon_draw_specification = {scale = 0.7},
    damaged_trigger_effect = hit_effects.entity(),
    fast_replaceable_group = "rci-rocketizer",
	graphics_set =
	{
		animation = {
			layers = {
				{
					filename = "__RocketCargoInsertion__/graphics/entity/rocketizer/rocketizer.png",
					priority = "extra-high",
					width = 64,
					height = 80,
					shift = util.by_pixel(-0.25, -0.5),
					scale = 0.5
				},
				{
					filename = "__RocketCargoInsertion__/graphics/entity/rocketizer/rocketizer-shadow.png",
					priority = "extra-high",
					width = 110,
					height = 46,
					shift = util.by_pixel(12.25, 8),
					draw_as_shadow = true,
					scale = 0.5
				}
			}
		}
	},
	crafting_categories = {"rci-rocketizer"},
	crafting_speed = 1.0,
    energy_source =
    {
      type = "void"
    },
	energy_usage = "75kW",

	--allowed_effects = {"speed", "consumption", "pollution"},
	effect_receiver = {uses_module_effects = false, uses_beacon_effects = false, uses_surface_effects = false},
	impact_category = "metal",
	vc_ignore = true,
    circuit_connector = rci_circuit_connector,
    circuit_wire_max_distance = default_circuit_wire_max_distance
}

local rci_data = { rci_category, rci_rocketizer_crafting, rocketizer_item, rocketizer_entity, rocketizer_recipe }

local rci_processing_unit = util.table.deepcopy(data.raw.item["processing-unit"])
rci_processing_unit.name = "rci-processing-unit"
rci_processing_unit.subgroup = "rci-rocketry"
rci_processing_unit.order = "a-a"
rci_processing_unit.icon = "__RocketCargoInsertion__/graphics/icons/rci-processing-unit.png"

local rci_low_density_structure = util.table.deepcopy(data.raw.item["low-density-structure"])
rci_low_density_structure.name = "rci-low-density-structure"
rci_low_density_structure.subgroup = "rci-rocketry"
rci_low_density_structure.order = "a-b"
rci_low_density_structure.icon = "__RocketCargoInsertion__/graphics/icons/rci-low-density-structure.png"

local rci_rocket_fuel = util.table.deepcopy(data.raw.item["rocket-fuel"])
rci_rocket_fuel.name = "rci-rocket-fuel"
rci_rocket_fuel.subgroup = "rci-rocketry"
rci_rocket_fuel.order = "a-c"
rci_rocket_fuel.icon = "__RocketCargoInsertion__/graphics/icons/rci-rocket-fuel.png"

if (subPU) then
	table.insert(rci_data, rci_processing_unit)
	table.insert(rci_data, rci_make_part_recipe("processing-unit", rci_processing_unit))
	rci_rocket_unlock_recipe("rci-processing-unit")
end
if (subLDS) then
	table.insert(rci_data, rci_low_density_structure)
	table.insert(rci_data, rci_make_part_recipe("low-density-structure", rci_low_density_structure))
	rci_rocket_unlock_recipe("rci-low-density-structure")
end
if (subFuel) then
	table.insert(rci_data, rci_rocket_fuel)
	table.insert(rci_data, rci_make_part_recipe("rocket-fuel", rci_rocket_fuel))
	rci_rocket_unlock_recipe("rci-rocket-fuel")	
end

if (subPU and subLDS and subFuel) then
	table.insert(rci_data, rci_make_combo_recipe("rci-rocket-combo"))
	rci_rocket_unlock_recipe("rci-rocket-combo")
end	

if (siloRecipes) then
	data.raw.recipe["rocket-part"].hide_from_player_crafting = false
	data.raw.recipe["rocket-part"].subgroup = "rci-rocketry"
	data.raw.recipe["rocket-part"].order = "b-a"
	
	if (subPU or subLDS or subFuel) then
		local rci_rocket_part = rci_make_rocket_recipe("rci-rocket-part", "b-b")
		rci_rocket_part.icon = "__RocketCargoInsertion__/graphics/icons/rci-rocket-part-full.png"
		rci_substitute(rci_rocket_part, true, true, true)
		table.insert(rci_data, rci_rocket_part)
		table.insert(productivity_recipes, "rci-rocket-part")
		rci_rocket_unlock_recipe("rci-rocket-part")
	end
	
	if (subPU and (subLDS or subFuel)) then
		local rci_pu_part = rci_make_rocket_recipe("rci-rocket-part-pu", "b-c")
		rci_pu_part.icon = nil
		rci_pu_part.icons = {
			{ icon = "__base__/graphics/icons/rocket-part.png", icon_size = 64, icon_mipmaps = 4 },
			{ icon = "__RocketCargoInsertion__/graphics/icons/rci-processing-unit.png", icon_size = 64, icon_mipmaps = 4, scale = 0.25, shift = {-8, -8} }
		}
		rci_substitute(rci_pu_part, true, false, false)
		table.insert(rci_data, rci_pu_part)
		table.insert(productivity_recipes, "rci-rocket-part-pu")
		rci_rocket_unlock_recipe("rci-rocket-part-pu")
	end
	
	if (subLDS and (subPU or subFuel)) then
		local rci_lds_part = rci_make_rocket_recipe("rci-rocket-part-lds", "b-d")
		rci_lds_part.icon = nil
		rci_lds_part.icons = {
			{ icon = "__base__/graphics/icons/rocket-part.png", icon_size = 64, icon_mipmaps = 4 },
			{ icon = "__RocketCargoInsertion__/graphics/icons/rci-low-density-structure.png", icon_size = 64, icon_mipmaps = 4, scale = 0.25, shift = {-8, -8} }
		}
		rci_substitute(rci_lds_part, false, true, false)
		table.insert(rci_data, rci_lds_part)
		table.insert(productivity_recipes, "rci-rocket-part-lds")
		rci_rocket_unlock_recipe("rci-rocket-part-lds")
	end
	
	if (subFuel and (subPU or subLDS)) then
		local rci_fuel_part = rci_make_rocket_recipe("rci-rocket-part-fuel", "b-e")
		rci_fuel_part.icon = nil
		rci_fuel_part.icons = {
			{ icon = "__base__/graphics/icons/rocket-part.png", icon_size = 64, icon_mipmaps = 4 },
			{ icon = "__RocketCargoInsertion__/graphics/icons/rci-rocket-fuel.png", icon_size = 64, icon_mipmaps = 4, scale = 0.25, shift = {-8, -8} }
		}
		rci_substitute(rci_fuel_part, false, false, true)
		table.insert(rci_data, rci_fuel_part)
		table.insert(productivity_recipes, "rci-rocket-part-fuel")
		rci_rocket_unlock_recipe("rci-rocket-part-fuel")
	end
		
	data.raw["rocket-silo"]["rocket-silo"].fixed_recipe = nil
else
	rci_substitute(data.raw.recipe["rocket-part"], true, true, true)
end

table.insert(data.raw.character.character.crafting_categories, "rci-rocketizer")
table.insert(data.raw["god-controller"].default.crafting_categories, "rci-rocketizer")
rci_rocket_unlock_recipe("rci-rocketizer")

data:extend(rci_data)

if (data.raw.technology["rocket-part-productivity"] and #productivity_recipes > 0) then
	for p=1,#productivity_recipes do
		table.insert(data.raw.technology["rocket-part-productivity"].effects, {
			type = "change-recipe-productivity",
			recipe = productivity_recipes[p],
			change = 0.1
		})
	end
end