if (settings.startup["rci-mode"].value == "proxy") then

	local function proxy_search(table_mode, en, search_size, search_type, search_name)
		local searchbox = {{en.position.x - search_size, en.position.y - search_size}, {en.position.x + search_size, en.position.y + search_size}}
		local result_tbl = en.surface.find_entities_filtered({area = searchbox, type = search_type, name = search_name})
		if (result_tbl and result_tbl[1] and result_tbl[1].valid) then
			if (table_mode) then
				return result_tbl
			else
				return result_tbl[1]
			end
		end
		return nil
	end

	local function proxy_built(event)
		local en = event.entity
		if (en and en.valid) then
			if (en.name == "rci-rocketizer") then
				local proxy = en
				local silo = proxy_search(false, proxy, 1, "rocket-silo")
				if (silo) then
					--game.print("Found silo " .. tostring(silo))
					proxy.proxy_target_entity = silo
					proxy.proxy_target_inventory = defines.inventory.rocket_silo_rocket
				end
			else 
				local silo = en
				local proxy = proxy_search(true, silo, 5, nil, "rci-rocketizer")
				if (proxy) then
					for i=1,#proxy do
						--game.print("Found target " .. tostring(proxy[i]) .. ": " .. tostring(proxy[i].proxy_target_entity))
						if (proxy[i].valid and not proxy[i].proxy_target_entity) then
							proxy[i].proxy_target_entity = silo
							proxy[i].proxy_target_inventory = defines.inventory.rocket_silo_rocket
						end
					end
				end
			end
		end	
	end

	local rocket_proxy_filters = {{filter = "type", type = "rocket-silo"}, {filter = "name", name = "rci-rocketizer"}}
	script.on_event(defines.events.on_built_entity, proxy_built, rocket_proxy_filters)
	script.on_event(defines.events.on_robot_built_entity, proxy_built, rocket_proxy_filters)
	script.on_event(defines.events.script_raised_built, proxy_built, rocket_proxy_filters)
	script.on_event(defines.events.script_raised_revive, proxy_built, rocket_proxy_filters)
	--[[
	script.on_event(defines.events.on_player_mined_entity, proxy_mined, rocket_proxy_filters)
	script.on_event(defines.events.on_robot_mined_entity, proxy_mined, rocket_proxy_filters)
	script.on_event(defines.events.on_entity_died, proxy_mined, rocket_proxy_filters)
	script.on_event(defines.events.script_raised_destroy, proxy_mined, rocket_proxy_filters)
	--]]
end