
local item =
{
  flags = {},
  icon = "__TurboBike__/graphics/icons/hyper-bike-icon.png",
  icon_size = 64,
  name = "hyper-bike",
  order = "b[personal-transport]-f[hyper-bike]",
  place_result = "hyper-bike",
  stack_size = 1,
  subgroup = "transport",
  type = "item-with-entity-data"
}

local recipe =
{
  enabled = false,
  ingredients = {
    {
      amount = 30,
      name = "low-density-structure",
      type = "item"
    },
    {
      amount = 10,
      name = "electric-engine-unit",
      type = "item"
    },
    {
      amount = 10,
      name = "supercapacitor",
      type = "item"
    },
    {
      amount = 2000,
      name = "lubricant",
      type = "fluid"
    },
  },
  name = "hyper-bike",
  results = {
    {
      amount = 1,
      name = "hyper-bike",
      type = "item"
    }
  },
  type = "recipe",
  energy_required = 20,
  category = "crafting-with-fluid"
}

local color = { 0.5, 0.5, 0.5, 0.5 }

local recycling =
{
  enabled = true,
  hidden = true,
  icons = {
    {
      icon = "__quality__/graphics/icons/recycling.png"
    },
    {
      icon = "__TurboBike__/graphics/icons/hyper-bike-icon.png",
      scale = 0.4
    },
    {
      icon = "__quality__/graphics/icons/recycling-top.png"
    }
  },
  crafting_machine_tint = {
    primary = color,
    secondary = color,
    tertiary = color,
    quaternary = color
  },
  ingredients = {
    {
      amount = 1,
      name = "hyper-bike",
      type = "item"
    }
  },
  name = "hyper-bike-recycling",
  localised_name = {
    "recipe-name.recycling",
    {
      "entity-name.hyper-bike"
    }
  },
  results = {
  {
    amount = 10,
    name = "low-density-structure",
    type = "item"
  },
  {
    amount = 5,
    name = "electric-engine-unit",
    type = "item"
  },
  {
    amount = 5,
    name = "supercapacitor",
    type = "item"
  },
  },
  type = "recipe",
  energy_required = 0.5,
  category = "recycling"
}

local tech =
{
  type = "technology",
  name = "hyper-bike",
  icon = "__TurboBike__/graphics/technology/hyper-bike-tech.png",
  icon_size = 128,
  prerequisites = {
    "turbo-bike",
    "electromagnetic-science-pack",
    "utility-science-pack"
  },
  effects =
  {
    {
      recipe = "hyper-bike",
      type = "unlock-recipe"
    },
  },
  unit = {
    count = 500,
    ingredients = {
      {"automation-science-pack", 1 },
      {"logistic-science-pack", 1 },
      {"chemical-science-pack", 1 },
      {"utility-science-pack", 1 },
      {"electromagnetic-science-pack", 1 },
    },
    time = 45
  }
}

local entity = {
  type = "car",
  name = "hyper-bike",
  icon = "__TurboBike__/graphics/icons/hyper-bike-icon.png",
  icon_size = 64;
  minable = {mining_time = 1, result = "hyper-bike"},
  flags = {
    "placeable-neutral",
    "player-creation",
    "placeable-off-grid",
    "not-flammable"
  },
  collision_mask = {
    layers = {
      is_object = true,
      train = true,
      car = true,
    }
  },
  terrain_friction_modifier = 0,
  surface_conditions = {
    {
      max = 5000,
      min = 500,
      property = "pressure"
    }
  },

  max_health = 400,
  effectivity = 0.06,
  energy_per_hit_point = 1,
  braking_power = "600kW",
  consumption = "1200kW",
  friction = 0.0075,
  rotation_speed = 0.01,
  weight = 45,
  inventory_size = 0,
  sound_minimum_speed = 0.25,
  resistances =
  {
    {
      type = "fire",
      percent = 50
    },
    {
      percent = 10,
      type = "impact"
    },
    {
      percent = 80,
      type = "acid"
    }
  },
  collision_box = {{-0.5, -1}, {0.5, 1}},
  selection_box = {{-0.5, -1}, {0.5, 1}},
  corpse = "medium-remnants",
  dying_explosion = "car-explosion",
  energy_source =
  {
    effectivity = 1,
    fuel_categories = {
      "chemical"
    },
    fuel_inventory_size = 1,
    smoke =
    {
      {
        name = "smoke",
        deviation = {0.25, 0.25},
        frequency = 150,
        position = {0, 1.5},
        slow_down_factor = 0.9,
        starting_frame = 3,
        starting_frame_deviation = 5,
        starting_frame_speed = 0,
        starting_frame_speed_deviation = 5
      }
    },
    type = "burner"
  },
  light = {
    {
      color = {
        b = 0.3,
        g = 0.77000000000000002,
        r = 0.92000000000000011
      },
      intensity = 0.6,
      minimum_darkness = 0.3,
      picture = {
        filename = "__core__/graphics/light-cone.png",
        flags = {
          "light"
        },
        height = 200,
        priority = "extra-high",
        scale = 2,
        width = 200
      },
      shift = {
        0,
        -13
      },
      size = 2,
      type = "oriented"
    }
  },
  alert_icon_shift = {
    0,
    -0.40625
  },
  animation =
  {
    layers =
    {
      {
        width = 120,
        height = 96,
        frame_count = 1,
        direction_count = 64,
        shift = {0, 0},
        animation_speed = 8,
        max_advance = 0.2,
        axially_symmetrical = false,
        stripes = {
          {
            filename = "__TurboBike__/graphics/entity/hyper-bike.png",
            height_in_frames = 8,
            width_in_frames = 8
          },
          {
            filename = "__TurboBike__/graphics/entity/hyper-bike.png",
            height_in_frames = 8,
            width_in_frames = 8
          },
          {
            filename = "__TurboBike__/graphics/entity/hyper-bike.png",
            height_in_frames = 8,
            width_in_frames = 8
          }
        }
      }
    }
  },
  damaged_trigger_effect = {
    damage_type_filters = "fire",
    entity_name = "spark-explosion",
    offset_deviation = {
      {
        -0.5,
        -0.5
      },
      {
        0.5,
        0.5
      }
    },
    offsets = {
      {
        0,
        1
      }
    },
    type = "create-entity"
  },
  mined_sound = {
    filename = "__core__/sound/deconstruct-medium.ogg",
    volume = 0.8
  },
  open_sound = { filename = "__base__/sound/car-door-open.ogg", volume=0.7 },
  close_sound = { filename = "__base__/sound/car-door-close.ogg", volume = 0.7 },
  sound_minimum_speed = 0.25,
  sound_no_fuel = {
    {
      filename = "__base__/sound/fight/car-no-fuel-1.ogg",
      volume = 0.6
    }
  },
  sound_scaling_ratio = 0.8,
  stop_trigger = {
    {
      sound = {
        {
          filename = "__base__/sound/car-breaks.ogg",
          volume = 0.2
        }
      },
      type = "play-sound"
    }
  },
  stop_trigger_speed = 0.15,
  render_layer = "object",
  vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
  working_sound = {
    activate_sound = {
      filename = "__TurboBike__/sound/bike-engine-start.ogg",
      volume = 0.5
    },
    deactivate_sound = {
      filename = "__TurboBike__/sound/bike-engine-stop.ogg",
      volume = 0.5
    },
    match_speed_to_activity = true,
    sound = {
      filename = "__TurboBike__/sound/bike-engine.ogg",
      volume = 0.5
    }
  }
}

data:extend{item, recipe, recycling, entity, tech}
